package com.trafficparrot.examples.jms;

import com.trafficparrot.examples.tools.jms.JmsClient;
import org.assertj.core.api.Assertions;
import org.junit.Test;

import javax.jms.JMSException;
import java.time.Duration;
import java.time.LocalDateTime;

import static org.assertj.core.api.Assertions.assertThat;

public class HelloWorldJmsQueueIntegrationTest {
    private final JmsClient jmsClient = new JmsClient("tcp://localhost:19091");

    @Test(timeout = 30_000)
    public void helloWorldJmsQueue() throws JMSException {
        jmsClient.sendTextMessageToQueue("request.queue", "hello");

        String response = jmsClient.consumeTextMessageFromQueue("response.queue");

        assertThat(response).isEqualTo("world");
    }

    @Test(timeout = 30_000)
    public void helloWorldJmsQueueWithFixedDelay() throws JMSException {
        jmsClient.sendTextMessageToQueue("request.queue", "hello-delay");

        long start = System.nanoTime();
        String response = jmsClient.consumeTextMessageFromQueue("response.queue");
        long end = System.nanoTime();

        assertThat(response).isEqualTo("world-delay");
        assertThat(Duration.ofNanos(end - start)).isGreaterThanOrEqualTo(Duration.ofMillis(900));
    }
}
