package com.trafficparrot.examples.tools.jms;

import javax.jms.*;
import java.lang.IllegalStateException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

import static java.lang.String.format;
import static java.util.concurrent.TimeUnit.SECONDS;

public class WaitForOneJmsMessage implements MessageListener {
    public final CountDownLatch countDownLatch;
    public final Connection connection;
    public final Session session;
    public final MessageConsumer consumer;

    private String message;

    WaitForOneJmsMessage(CountDownLatch countDownLatch, Connection connection, Session session, MessageConsumer consumer) {
        this.countDownLatch = countDownLatch;
        this.connection = connection;
        this.session = session;
        this.consumer = consumer;
    }

    @Override
    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage) message;
            try {
                this.message = textMessage.getText();
            } catch (JMSException e) {
                throw new IllegalStateException(e);
            }
        } else {
            throw new IllegalArgumentException(message.toString());
        }

        countDownLatch.countDown();
    }

    public String awaitMessage() throws InterruptedException, JMSException {
        return awaitMessage(10, SECONDS);
    }

    public String awaitMessage(int timeout, TimeUnit timeUnit) throws InterruptedException, JMSException {
        boolean await = countDownLatch.await(timeout, timeUnit);
        close();
        if (!await) {
            throw new IllegalStateException(format("0/1 messages arrived in %s %s", timeout, timeUnit));
        }
        return message;
    }

    public void close() throws JMSException {
        consumer.close();
        session.close();
        connection.close();
    }
}
