package com.trafficparrot.examples.hello.ibmmq;

import com.ibm.mq.MQException;
import org.junit.After;
import org.junit.Test;

import java.io.IOException;

import static org.assertj.core.api.Assertions.assertThat;

public class HelloWorldIbmMqTopicIntegrationTest {
    private final IbmMqClient ibmMqClient = new IbmMqClient();
    private WaitForOneIbmMqMessage waitForOneIbmMqMessage;

    @Test(timeout = 30_000)
    public void helloWorldIbmMqTopic() throws IOException, MQException, InterruptedException {
        waitForOneIbmMqMessage = ibmMqClient.listenOnIbmMqTopic("DEV.RESPONSE.TOPIC");
        ibmMqClient.sendIbmMqMessageToTopic("DEV.REQUEST.TOPIC", "hello");

        String response = waitForOneIbmMqMessage.awaitMessage();

        assertThat(response).isEqualTo("world");
    }

    @After
    public void tearDown() throws MQException {
        if (waitForOneIbmMqMessage != null) {
            waitForOneIbmMqMessage.close();
        }
    }
}
