package com.trafficparrot.examples.object;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ExamplePerson implements Serializable {
    private static final long serialVersionUID = 100L;

    private final String name;
    private final int height;
    private final double weight;
    private final List<ExamplePerson> children;

    @SuppressWarnings("unused") // default constructor is required by Traffic Parrot
    public ExamplePerson() {
        this(null, -1, -1, null, null);
    }

    public ExamplePerson(String name, int height, double weight, ExamplePerson... children) {
        this.name = name;
        this.height = height;
        this.weight = weight;
        this.children = Arrays.asList(children);
    }

    @Override
    public String toString() {
        return "ExamplePerson{" +
                "name='" + name + '\'' +
                ", height=" + height +
                ", weight=" + weight +
                ", children=" + children +
                '}';
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) return true;
        if (object == null || getClass() != object.getClass()) return false;
        ExamplePerson that = (ExamplePerson) object;
        return height == that.height &&
                Double.compare(that.weight, weight) == 0 &&
                Objects.equals(name, that.name) &&
                Objects.equals(children, that.children);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, height, weight, children);
    }
}