package com.trafficparrot.examples.grpc;

import com.trafficparrot.examples.tools.grpc.OrderClient;
import org.junit.Test;

import static com.google.common.net.HostAndPort.fromParts;
import static com.trafficparrot.examples.tools.grpc.OrderClient.createNonTlsOrderClient;
import static org.assertj.core.api.Assertions.assertThat;


public class DataLookupIntegrationTest {
    private final OrderClient orderClient = createNonTlsOrderClient(fromParts("localhost", 5552));

    @Test
    public void lookupUsingRequestData() {
        // This corresponds to the 1,message-one row in messages.csv
        String example1 = orderClient.order(1, 100).getMessage();
        assertThat(example1).isEqualTo("message-one");

        // This corresponds to the 3,message-three row in messages.csv
        String example2 = orderClient.order(3, 100).getMessage();
        assertThat(example2).isEqualTo("message-three");
    }
}
