package com.trafficparrot.examples.http;

import com.trafficparrot.examples.tools.http.HttpClient;
import org.junit.Test;

import java.io.IOException;

import static org.assertj.core.api.Assertions.assertThat;

public class HelloWorldHttpIntegrationTest {
    private final HttpClient httpClient = new HttpClient("http://localhost:18081");

    @Test(timeout = 30_000)
    public void helloHttpWorld() throws IOException {
        httpClient.displayHttpMappingsContaining("hello");

        String response = httpClient.post("/path", "hello");

        assertThat(response).isEqualTo("world");
    }
}
