package com.trafficparrot.examples.http;

import com.trafficparrot.examples.tools.http.HttpClient;
import org.junit.Test;

import java.io.IOException;

import static org.assertj.core.api.Assertions.assertThat;

public class SharedExcelFileIntegrationTest {
    private final HttpClient httpClient = new HttpClient("http://localhost:18081");

    @Test
    public void sharedExcelFileReadAndUpdated() throws IOException {
        httpClient.displayHttpMappingsContaining("SharedExcelFileIntegrationTest");

        String notFound = httpClient.get("/accounts/999/balance", 404);
        assertThat(notFound).isEqualToIgnoringWhitespace("{\n" +
                "    \"error_code\": \"50\",\n" +
                "    \"error_message\": \"Account not found\"\n" +
                "}");

        String initial = httpClient.get("/accounts/101/balance");
        assertThat(initial).isEqualToIgnoringWhitespace("{\n" +
                "    \"account_id\": 101,\n" +
                "    \"balance\": 100\n" +
                "}");

        String spend = httpClient.post("/accounts/101/spend/70");
        assertThat(spend).isEqualToIgnoringWhitespace("{\n" +
                "    \"account_id\": 101,\n" +
                "    \"balance\": 30\n" +
                "}");

        String after = httpClient.get("/accounts/101/balance");
        assertThat(after).isEqualToIgnoringWhitespace("{\n" +
                "    \"account_id\": 101,\n" +
                "    \"balance\": 30\n" +
                "}");

        String rejected = httpClient.post("/accounts/101/spend/31", 400);
        assertThat(rejected).isEqualToIgnoringWhitespace("{\n" +
                "    \"error_code\": \"70\",\n" +
                "    \"error_message\": \"Insufficient balance\"\n" +
                "}");
    }
}
