package com.trafficparrot.examples.http;

import com.trafficparrot.examples.tools.http.HttpClient;
import org.junit.Test;

import java.io.IOException;
import java.time.Duration;

import static org.assertj.core.api.Assertions.assertThat;

public class SimulateHttpDelaysIntegrationTest {
    private final HttpClient httpClient = new HttpClient("http://localhost:18081");

    @Test(timeout = 30_000)
    public void fixedDelay() throws IOException {
        httpClient.displayHttpMappingsContaining("fixedDelay");

        long start = System.nanoTime();

        String response = httpClient.get("/fixedDelay");

        long end = System.nanoTime();

        assertThat(response).isEqualTo("response");
        assertThat(Duration.ofNanos(end - start)).isGreaterThan(Duration.ofMillis(500));
    }

    @Test(timeout = 30_000)
    public void uniformDelay() throws IOException {
        httpClient.displayHttpMappingsContaining("uniformDelay");

        long start = System.nanoTime();

        String response = httpClient.get("/uniformDelay");

        long end = System.nanoTime();

        assertThat(response).isEqualTo("response");
        assertThat(Duration.ofNanos(end - start)).isGreaterThan(Duration.ofMillis(150));
    }

    @Test(timeout = 30_000)
    public void logNormalDelay() throws IOException {
        httpClient.displayHttpMappingsContaining("logNormalDelay");

        long start = System.nanoTime();

        String response = httpClient.get("/logNormalDelay");

        long end = System.nanoTime();

        assertThat(response).isEqualTo("response");
        assertThat(Duration.ofNanos(end - start)).isGreaterThan(Duration.ofMillis(50));
    }

    @Test(timeout = 30_000)
    public void chunkedDribbleDelay() throws IOException {
        httpClient.displayHttpMappingsContaining("chunkedDribbleDelay");

        long start = System.nanoTime();

        String response = httpClient.get("/chunkedDribbleDelay");

        long end = System.nanoTime();

        assertThat(response).isEqualTo("response");
        assertThat(Duration.ofNanos(end - start)).isGreaterThan(Duration.ofMillis(500));
    }
}
