package com.trafficparrot.examples.jms;

import com.trafficparrot.examples.object.ExamplePerson;
import com.trafficparrot.examples.tools.jms.JmsClient;
import org.junit.Test;

import javax.jms.JMSException;
import java.io.IOException;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

public class ObjectJmsQueueIntegrationTest {

    private final JmsClient jmsClient = new JmsClient("tcp://localhost:19091");

    @Test(timeout = 30_000)
    public void replayJavaObject() throws IOException, JMSException, ClassNotFoundException {
        jmsClient.sendObjectMessageToQueue("request.queue.object", requestObjectForEqualToJsonMatch());

        ExamplePerson response = (ExamplePerson) jmsClient.consumeObjectMessage("response.queue.object");

        assertThat(response, is(expectedResponse()));
    }

    @Test(timeout = 30_000)
    public void matchJavaObjectUsingJsonPathEquality() throws JMSException, IOException, ClassNotFoundException {
        jmsClient.sendObjectMessageToQueue("request.queue.object", requestObjectForJsonPathEqualMatch());

        ExamplePerson response = (ExamplePerson) jmsClient.consumeObjectMessage("response.queue.object");

        assertThat(response, is(expectedResponse()));
    }

    @Test(timeout = 30_000)
    public void matchJavaObjectUsingJsonPathWithRegex() throws JMSException, IOException, ClassNotFoundException {
        jmsClient.sendObjectMessageToQueue("request.queue.object", requestObjectForJsonPathWithRegexMatch());

        ExamplePerson response = (ExamplePerson) jmsClient.consumeObjectMessage("response.queue.object");

        assertThat(response, is(expectedResponse()));
    }

    @Test(timeout = 30_000)
    public void useRequestInResponseWithJsonPath() throws JMSException, IOException, ClassNotFoundException {
        int parentHeight = 111;
        ExamplePerson child = new ExamplePerson("Laura", 174, 33.9);
        jmsClient.sendObjectMessageToQueue("request.queue.object", requestObjectForUsingRequestInResponse(parentHeight, child));

        ExamplePerson response = (ExamplePerson) jmsClient.consumeObjectMessage("response.queue.object");

        assertThat(response, is(expectedResponse(parentHeight, child)));
    }

    private ExamplePerson requestObjectForUsingRequestInResponse(int height, ExamplePerson child) {
        return new ExamplePerson("Use in response", height, 67.5, child);
    }

    private ExamplePerson requestObjectForJsonPathEqualMatch() {
        return new ExamplePerson("Bob", 180, 67.5);
    }

    private ExamplePerson requestObjectForJsonPathWithRegexMatch() {
        return new ExamplePerson("Henry Jones", 180, 67.5);
    }

    private ExamplePerson requestObjectForEqualToJsonMatch() {
        ExamplePerson sammy = new ExamplePerson("Sammy", 120, 44.5);
        ExamplePerson laura = new ExamplePerson("Laura", 174, 33.9);
        return new ExamplePerson("Bob", 180, 67.5, sammy, laura);
    }

    private ExamplePerson expectedResponse() {
        ExamplePerson laura = new ExamplePerson("Laura", 174, 33.9);
        return expectedResponse(180, laura);
    }

    private ExamplePerson expectedResponse(int parentHeight, ExamplePerson... children) {
        return new ExamplePerson("Bob", parentHeight, 67.5, children);
    }
}
