/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.http;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseTransformer;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpResponseTransformer
extends ResponseTransformer {
    protected final Logger logger = LoggerFactory.getLogger(HttpResponseTransformer.class);

    protected HttpResponseTransformer() {
    }

    public final Response transform(Request request, Response response, FileSource fileSource, Parameters parameters) {
        try {
            return this.doTransform(request, response, fileSource, parameters);
        }
        catch (Exception e) {
            String errorMessage = String.format("%s had a problem while transforming: %s. See logs for more details.", ((Object)((Object)this)).getClass().getCanonicalName(), e.getMessage());
            this.logger.error(errorMessage, (Throwable)e);
            return Response.response().body(errorMessage).status(500).build();
        }
    }

    protected abstract Response doTransform(Request var1, Response var2, FileSource var3, Parameters var4) throws Exception;

    public String getName() {
        String name = ((Object)((Object)this)).getClass().getSimpleName();
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public boolean applyGlobally() {
        return false;
    }
}

