/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class TransformedRequest
implements Request {
    private static final String NL = System.lineSeparator();
    private final String url;
    private final String absoluteUrl;
    private final RequestMethod method;
    private final String clientIp;
    private final HttpHeaders httpHeaders;
    private final ImmutableMap<String, Cookie> cookies;
    private final boolean browserProxyRequest;
    private final Body body;
    private final Collection<Request.Part> parts;
    private final String protocol;

    @Deprecated
    public TransformedRequest(String url, String absoluteUrl, RequestMethod method, String clientIp, HttpHeaders httpHeaders, ImmutableMap<String, Cookie> cookies, boolean browserProxyRequest, String stringBody, Collection<Request.Part> parts) {
        this(url, absoluteUrl, method, clientIp, httpHeaders, cookies, browserProxyRequest, stringBody, parts, "HTTP/1.1");
    }

    private TransformedRequest(String url, String absoluteUrl, RequestMethod method, String clientIp, HttpHeaders httpHeaders, ImmutableMap<String, Cookie> cookies, boolean browserProxyRequest, String stringBody, Collection<Request.Part> parts, String protocol) {
        this.url = url;
        this.absoluteUrl = absoluteUrl;
        this.method = method;
        this.clientIp = clientIp;
        this.httpHeaders = httpHeaders;
        this.cookies = cookies;
        this.browserProxyRequest = browserProxyRequest;
        this.body = Body.fromOneOf(null, (String)stringBody, null, null);
        this.parts = parts;
        this.protocol = protocol;
    }

    public static TransformedRequest like(Request request) {
        return new TransformedRequest(request.getUrl(), request.getAbsoluteUrl(), request.getMethod(), request.getClientIp(), HttpHeaders.copyOf((HttpHeaders)request.getHeaders()), (ImmutableMap<String, Cookie>)ImmutableMap.copyOf((Map)request.getCookies()), request.isBrowserProxyRequest(), request.getBodyAsString(), request.getParts(), request.getProtocol());
    }

    public static Charset contentEncoding(HttpHeaders headers) {
        if (headers == null) {
            return Charsets.UTF_8;
        }
        return TransformedRequest.contentEncoding(headers.getContentTypeHeader());
    }

    public static Charset contentEncoding(ContentTypeHeader contentTypeHeader) {
        if (contentTypeHeader != null) {
            return contentTypeHeader.charset();
        }
        return Charsets.UTF_8;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAbsoluteUrl() {
        return this.absoluteUrl;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public String getScheme() {
        throw new UnsupportedOperationException("NYI");
    }

    public String getHost() {
        throw new UnsupportedOperationException("NYI");
    }

    public int getPort() {
        throw new UnsupportedOperationException("NYI");
    }

    public String getClientIp() {
        return this.clientIp;
    }

    @JsonIgnore
    public String getHeader(String key) {
        HttpHeader header = this.header(key);
        if (header.isPresent()) {
            return header.firstValue();
        }
        return null;
    }

    public HttpHeader header(String key) {
        return this.httpHeaders.getHeader(key);
    }

    public ContentTypeHeader contentTypeHeader() {
        if (this.httpHeaders != null) {
            return this.httpHeaders.getContentTypeHeader();
        }
        return null;
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    public boolean containsHeader(String key) {
        return false;
    }

    public Set<String> getAllHeaderKeys() {
        return this.httpHeaders.keys();
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public ImmutableMap<String, Cookie> getCookies() {
        return this.cookies;
    }

    public QueryParameter queryParameter(String key) {
        throw new UnsupportedOperationException("NYI");
    }

    public boolean isBrowserProxyRequest() {
        return this.browserProxyRequest;
    }

    @JsonIgnore
    public Optional<Request> getOriginalRequest() {
        return Optional.absent();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public byte[] getBody() {
        return this.body.asBytes();
    }

    public String getBodyAsString() {
        return this.body.asString();
    }

    @JsonProperty(value="bodyAsBase64")
    public String getBodyAsBase64() {
        return Encoding.encodeBase64((byte[])this.body.asBytes());
    }

    @JsonIgnore
    public boolean isMultipart() {
        return this.parts != null && this.parts.size() > 0;
    }

    public Collection<Request.Part> getParts() {
        return this.parts;
    }

    @JsonIgnore
    public Request.Part getPart(String name) {
        return this.parts != null && name != null ? this.parts.stream().filter(input -> name.equals(input.getName())).findFirst().get() : null;
    }

    public TransformedRequest withTransformBody(BodyTransformer bodyTransformer) {
        String transformedBody = bodyTransformer.transform(this.body.asString());
        return new TransformedRequest(this.url, this.absoluteUrl, this.method, this.clientIp, this.httpHeaders, this.cookies, this.browserProxyRequest, transformedBody, this.parts, this.protocol);
    }

    public TransformedRequest withHeader(HttpHeader header) {
        return new TransformedRequest(this.url, this.absoluteUrl, this.method, this.clientIp, this.httpHeaders.plus(new HttpHeader[]{header}), this.cookies, this.browserProxyRequest, this.getBodyAsString(), this.parts, this.protocol);
    }

    public String toString() {
        return "TransformedRequest{" + NL + "url='" + this.url + '\'' + NL + "absoluteUrl='" + this.absoluteUrl + '\'' + NL + "method=" + this.method + NL + "clientIp='" + this.clientIp + '\'' + NL + "httpHeaders=" + NL + this.asString(this.httpHeaders) + "cookies=" + NL + this.asString(this.cookies) + "browserProxyRequest=" + this.browserProxyRequest + NL + "body='" + this.body.asString() + "'" + NL + "parts=" + this.parts + '}';
    }

    private String asString(ImmutableMap<String, Cookie> cookies) {
        StringBuilder result = new StringBuilder();
        for (String key : cookies.keySet()) {
            result.append("    ").append(key).append(": ").append(String.join((CharSequence)",", (Iterable<? extends CharSequence>)((Cookie)cookies.get((Object)key)).getValues())).append(NL);
        }
        return result.toString();
    }

    private String asString(HttpHeaders httpHeaders) {
        StringBuilder result = new StringBuilder();
        Collection all = httpHeaders.all();
        for (HttpHeader httpHeader : all) {
            result.append("    ").append(httpHeader.key()).append(": ").append(httpHeader.values()).append(NL);
        }
        return result.toString();
    }

    public static interface BodyTransformer {
        public String transform(String var1);
    }
}

