/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.internal.encoding;

import com.google.common.primitives.Bytes;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FindAndReplaceBytes {
    public static byte[] findAndReplaceShortUtf(byte[] bytes, String find, String replace) throws IOException {
        return FindAndReplaceBytes.findAndReplaceBytes(bytes, FindAndReplaceBytes.utfBytes(find), FindAndReplaceBytes.utfBytes(replace));
    }

    public static byte[] findAndReplaceBytes(byte[] array, byte[] find, byte[] replace) {
        List<Integer> occurrences = FindAndReplaceBytes.findOccurrences(array, find);
        byte[][] pieces = new byte[occurrences.size() * 2 + 1][];
        int position = 0;
        for (int i = 0; i < occurrences.size(); ++i) {
            int occurrence = occurrences.get(i);
            byte[] before = Arrays.copyOfRange(array, position, occurrence);
            pieces[2 * i] = before;
            pieces[2 * i + 1] = replace;
            position = occurrence + find.length;
        }
        byte[] after = Arrays.copyOfRange(array, position, array.length);
        pieces[occurrences.size() * 2] = after;
        return Bytes.concat((byte[][])pieces);
    }

    public static List<Integer> findOccurrences(byte[] array, byte[] search) {
        ArrayList<Integer> occurrences = new ArrayList<Integer>();
        for (int i = 0; i < array.length - search.length + 1; ++i) {
            if (!FindAndReplaceBytes.occurs(array, i, search)) continue;
            occurrences.add(i);
            i += search.length - 1;
        }
        return occurrences;
    }

    private static boolean occurs(byte[] array, int offset, byte[] search) {
        for (int j = 0; j < search.length; ++j) {
            if (array[offset + j] == search[j]) continue;
            return false;
        }
        return true;
    }

    private static byte[] utfBytes(String string) throws IOException {
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream output = new DataOutputStream(bytes);){
                output.writeUTF(string);
                byArray = bytes.toByteArray();
            }
            return byArray;
        }
    }
}

