/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.internal.encoding;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.trafficparrot.sdk.internal.encoding.FindAndReplaceBytes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Type;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SyntheticState;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unsynchronized.jdeserialize.arrayobj;
import org.unsynchronized.jdeserialize.classdesc;
import org.unsynchronized.jdeserialize.classobj;
import org.unsynchronized.jdeserialize.content;
import org.unsynchronized.jdeserialize.enumobj;
import org.unsynchronized.jdeserialize.field;
import org.unsynchronized.jdeserialize.fieldtype;
import org.unsynchronized.jdeserialize.instance;
import org.unsynchronized.jdeserialize.jdeserialize;
import org.unsynchronized.jdeserialize.stringobj;

public class ObjectSerializedRepresentation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectSerializedRepresentation.class);
    private static final String GENERATED_BY_TRAFFIC_PARROT = "$TrafficParrot$";
    private static final Lock CLASS_LOADING_LOCK = new ReentrantLock();
    private static final File CLASS_FILE_LOCATION = new File("lib" + File.separator + "trafficparrot" + File.separator + "generated");
    public static ObjectSerializedRepresentation OBJECT_SERIALIZED_REPRESENTATION = new ObjectSerializedRepresentation(LOGGER, CLASS_FILE_LOCATION);
    private final ConcurrentHashMap<String, Class<?>> classAliases = new ConcurrentHashMap();
    private final Set<String> nullClasses = Sets.newConcurrentHashSet();
    private final Set<String> notNullClasses = Sets.newConcurrentHashSet();
    private final ConcurrentHashMap<String, String> enclosingClasses = new ConcurrentHashMap();
    private final Set<instance> seen = Sets.newConcurrentHashSet();
    private final Logger logger;
    private final File classFileLocation;

    @VisibleForTesting
    public ObjectSerializedRepresentation(Logger logger, File classFileLocation) {
        this.logger = logger;
        this.classFileLocation = classFileLocation.getAbsoluteFile();
        logger.info("Storing dynamic class files in: " + classFileLocation.getAbsolutePath());
    }

    public void loadGeneratedClasses() throws IOException {
        Files.createDirectories(this.classFileLocation.toPath(), new FileAttribute[0]);
        Files.walkFileTree(this.classFileLocation.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                if (attributes.isRegularFile()) {
                    ObjectSerializedRepresentation.this.loadGeneratedAlias(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void loadGeneratedAlias(Path classFile) {
        String externalClassName;
        String internalClassName = this.className(classFile);
        if (!internalClassName.equals(externalClassName = this.externalClassName(internalClassName))) {
            try {
                this.classAliases.put(externalClassName, Class.forName(internalClassName));
                this.logger.info("Loaded: " + externalClassName);
            }
            catch (ClassNotFoundException e) {
                this.logger.error("Could not load: " + externalClassName, (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    public String className(Path classFile) {
        return classFile.toAbsolutePath().toString().replaceFirst(".*" + Pattern.quote(this.classFileLocation.getPath() + File.separator), "").replace(".class", "").replace(File.separatorChar, '.');
    }

    public String internalClassName(String value) {
        Class<?> alias = this.classAliases.get(value);
        if (alias != null) {
            return alias.getName();
        }
        return value;
    }

    public String externalClassName(String name) {
        return name.replaceAll(Pattern.quote(GENERATED_BY_TRAFFIC_PARROT) + ".*", "");
    }

    public byte[] writeObjectBytes(Object object) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(object);
                byte[] bytes = byteArrayOutputStream.toByteArray();
                byArray = this.replaceGeneratedWithActual(bytes);
            }
            return byArray;
        }
    }

    public Optional<Object> tryToReadObject(byte[] bytes) {
        if (ObjectSerializedRepresentation.notJavaSerializationHeader(bytes)) {
            return Optional.empty();
        }
        try {
            return Optional.of(ObjectSerializedRepresentation.bytesToJavaObject(bytes));
        }
        catch (InvalidClassException e) {
            this.logger.error("The serialized object class is invalid", (Throwable)e);
            return Optional.empty();
        }
        catch (InvalidObjectException | ClassNotFoundException original) {
            try {
                return this.tryToReadShadowObjectAsJavaObject(bytes);
            }
            catch (Throwable shadowClassException) {
                ClassNotFoundException withCause = new ClassNotFoundException(original.getMessage(), shadowClassException);
                this.logger.error("The serialized object class is not on the Traffic Parrot classpath and could not be dynamically generated", (Throwable)withCause);
                return Optional.empty();
            }
        }
        catch (EOFException | StreamCorruptedException e) {
            LOGGER.debug("Does not look like this is a serialized Java object", (Throwable)e);
            return Optional.empty();
        }
        catch (Throwable e) {
            this.logger.error("Problem while reading object", e);
            return Optional.empty();
        }
    }

    public Optional<content> tryToReadShadowObject(byte[] bytes) throws IOException {
        if (ObjectSerializedRepresentation.notJavaSerializationHeader(bytes)) {
            return Optional.empty();
        }
        jdeserialize jdeserialize2 = new jdeserialize();
        jdeserialize2.run((InputStream)new ByteArrayInputStream(bytes), true);
        List content2 = jdeserialize2.getContent();
        if (content2.size() != 1) {
            LOGGER.warn("Expected a single Java serialized object but found " + content2.size());
            return Optional.empty();
        }
        return Optional.of((content)content2.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Object> tryToReadShadowObjectAsJavaObject(byte[] bytes) throws IOException, ClassNotFoundException {
        CLASS_LOADING_LOCK.lock();
        try {
            Optional<content> shadowObject = this.tryToReadShadowObject(bytes);
            if (shadowObject.isPresent()) {
                this.seen.clear();
                this.nullClasses.clear();
                this.notNullClasses.clear();
                this.enclosingClasses.clear();
                this.loadValue(shadowObject.get());
                byte[] generated = this.replaceActualWithGenerated(bytes);
                Optional<Object> optional = Optional.of(ObjectSerializedRepresentation.bytesToJavaObject(generated));
                return optional;
            }
            Optional<Object> optional = Optional.empty();
            return optional;
        }
        finally {
            CLASS_LOADING_LOCK.unlock();
        }
    }

    private static boolean notJavaSerializationHeader(byte[] bytes) {
        return bytes[0] != -84 || bytes[1] != -19;
    }

    private byte[] replaceGeneratedWithActual(byte[] bytes) throws IOException {
        for (String className : this.classAliases.keySet()) {
            String alias = this.classAliases.get(className).getName();
            bytes = this.findAndReplaceClass(bytes, alias, className);
        }
        return bytes;
    }

    private byte[] replaceActualWithGenerated(byte[] bytes) throws IOException {
        for (String className : this.classAliases.keySet()) {
            String alias = this.classAliases.get(className).getName();
            bytes = this.findAndReplaceClass(bytes, className, alias);
        }
        return bytes;
    }

    private byte[] findAndReplaceClass(byte[] bytes, String className, String alias) throws IOException {
        byte[] original = bytes;
        bytes = FindAndReplaceBytes.findAndReplaceShortUtf(bytes, this.arrayFieldDescriptor(className), this.arrayFieldDescriptor(alias));
        if (!Arrays.equals(original, bytes = FindAndReplaceBytes.findAndReplaceShortUtf(bytes, this.arrayClassName(className), this.arrayClassName(alias)))) {
            return bytes;
        }
        bytes = FindAndReplaceBytes.findAndReplaceShortUtf(bytes, this.fieldDescriptor(className), this.fieldDescriptor(alias));
        bytes = FindAndReplaceBytes.findAndReplaceShortUtf(bytes, className, alias);
        return bytes;
    }

    private void loadInstance(instance instance2) throws ClassNotFoundException, IOException {
        for (classdesc innerClass : instance2.classdesc.innerclasses) {
            this.enclosingClasses.put(innerClass.name, instance2.classdesc.name);
        }
        switch (instance2.classdesc.classtype) {
            case NORMALCLASS: {
                this.loadNormalInstance(instance2, false);
                break;
            }
            case PROXYCLASS: {
                this.loadProxyInstance(instance2);
                break;
            }
            default: {
                throw new ClassNotFoundException("Unknown class type: " + instance2.classdesc.classtype);
            }
        }
    }

    private void loadProxyInstance(instance instance2) throws ClassNotFoundException, IOException {
        Collection instanceFieldData = instance2.fielddata.values();
        Preconditions.checkState((instanceFieldData.size() == 1 ? 1 : 0) != 0);
        Collection fieldValues = ((Map)instanceFieldData.iterator().next()).values();
        Preconditions.checkState((fieldValues.size() == 1 ? 1 : 0) != 0);
        instance handler = (instance)fieldValues.iterator().next();
        if (!instance2.classdesc.annotations.isEmpty()) {
            throw new ClassNotFoundException(String.format("Proxy class handler '%s' could not be generated since it has been annotated with a custom annotateProxyClass method", handler.classdesc.name));
        }
        for (String proxyInterface : this.proxyInterfaces(instance2.classdesc)) {
            this.loadInterface(proxyInterface);
        }
        this.loadNormalInstance(handler, true);
    }

    private void loadNormalInstance(instance instance2, boolean isInvocationHandler) throws ClassNotFoundException, IOException {
        if (this.seen.contains(instance2)) {
            throw new ClassNotFoundException(String.format("Class '%s' could not be generated since it is part of a circular dependency", instance2.classdesc.name));
        }
        this.seen.add(instance2);
        for (Map classFields : instance2.fielddata.values()) {
            for (Map.Entry entry : classFields.entrySet()) {
                field field2 = (field)entry.getKey();
                Object value = entry.getValue();
                if (field2.type == fieldtype.OBJECT) {
                    String fieldClassName = this.className(field2.classname.value);
                    if (value == null) {
                        this.nullClasses.add(fieldClassName);
                    } else {
                        this.notNullClasses.add(fieldClassName);
                    }
                } else if (field2.type == fieldtype.ARRAY) {
                    arrayobj array = (arrayobj)value;
                    String fieldComponentClassName = this.className(this.stripArrayPrefix(field2.classname.value));
                    if (this.alwaysNull(array)) {
                        this.nullClasses.add(fieldComponentClassName);
                    } else {
                        this.notNullClasses.add(fieldComponentClassName);
                    }
                }
                if (this.innerClassReferenceAlreadyLoaded(field2, value)) continue;
                this.loadValue(value);
            }
        }
        this.notNullClasses.add(instance2.classdesc.name);
        this.nullClasses.removeAll(this.notNullClasses);
        for (String nullClass : this.nullClasses) {
            this.loadNullClass(nullClass);
        }
        this.loadClass(instance2.classdesc, isInvocationHandler);
    }

    private boolean innerClassReferenceAlreadyLoaded(field field2, Object value) {
        return value instanceof instance && (field2.isInnerClassReference() || this.enclosingClasses.containsKey(this.className(field2.classname.value))) && this.seen.contains(value);
    }

    private boolean alwaysNull(arrayobj array) {
        for (Object data : array.data) {
            if (data == null) continue;
            return false;
        }
        return true;
    }

    private void loadValue(Object value) throws ClassNotFoundException, IOException {
        if (value instanceof enumobj) {
            enumobj enumobj2 = (enumobj)value;
            this.loadEnum(enumobj2.classdesc);
        } else if (value instanceof instance) {
            instance fieldInstance = (instance)value;
            this.loadInstance(fieldInstance);
        } else if (value instanceof arrayobj) {
            arrayobj arrayobj2 = (arrayobj)value;
            for (Object element : arrayobj2.data) {
                this.loadValue(element);
            }
        } else if (value instanceof classobj) {
            classobj classobj2 = (classobj)value;
            this.loadClass(classobj2.classdesc, false);
        } else if (value instanceof content && !(value instanceof stringobj)) {
            throw new UnsupportedOperationException("Unsupported field type: " + value.getClass());
        }
    }

    private void loadInterface(String name) throws IOException {
        Optional<Class<?>> alreadyLoadedClass = this.alreadyLoadedClass(name);
        if (alreadyLoadedClass.isPresent()) {
            return;
        }
        this.load(new ByteBuddy().makeInterface().name(name));
    }

    private void loadNullClass(String name) throws IOException {
        Optional<Class<?>> alreadyLoadedClass = this.alreadyLoadedClass(name);
        if (alreadyLoadedClass.isPresent()) {
            return;
        }
        if (this.classAliases.containsKey(name)) {
            return;
        }
        String alwaysNullClassName = this.alwaysNullClassName(name);
        Class<?> loaded = this.load(new ByteBuddy().subclass(Object.class).implement(new Type[]{Serializable.class}).name(alwaysNullClassName));
        this.recordAlias(name, loaded);
        this.logger.warn(String.format("Class '%s' was partially generated. Only null values are supported for fields of this type since Traffic Parrot did not see the serialized class definition.", name));
    }

    private String alwaysNullClassName(String name) {
        return name + GENERATED_BY_TRAFFIC_PARROT + "AlwaysNull";
    }

    private void loadEnum(classdesc classdesc2) throws IOException {
        Optional<Class<?>> alreadyLoadedClass = this.alreadyLoadedClass(classdesc2.name);
        if (alreadyLoadedClass.isPresent()) {
            return;
        }
        Set<String> existingEnumConstants = this.existingEnumConstants(classdesc2);
        Sets.SetView newConstants = Sets.difference((Set)classdesc2.enumconstants, existingEnumConstants);
        if (newConstants.isEmpty()) {
            return;
        }
        Sets.SetView allConstants = Sets.union(existingEnumConstants, (Set)classdesc2.enumconstants);
        String alias = this.generateClassAlias(classdesc2.name);
        Class<?> loaded = this.load(new ByteBuddy().makeEnumeration((Collection)allConstants).name(alias));
        this.recordAlias(classdesc2.name, loaded);
        this.logger.info(String.format("Enum '%s' was generated successfully with constants %s", classdesc2.name, allConstants));
    }

    private void deleteClassFile(String name) {
        Path toDelete = this.classFileLocation.toPath().resolve(name.replace('.', File.separatorChar) + ".class");
        try {
            Files.delete(toDelete);
        }
        catch (IOException e) {
            this.logger.warn("Could not delete class file: " + toDelete, (Throwable)e);
        }
    }

    private Class<?> load(DynamicType.Builder<?> byteBuddy) throws IOException {
        DynamicType.Unloaded make = byteBuddy.make();
        make.saveIn(this.classFileLocation);
        return make.load(this.getClass().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
    }

    private Set<String> existingEnumConstants(classdesc classdesc2) {
        HashSet<String> existingConstants = new HashSet<String>();
        if (this.classAliases.containsKey(classdesc2.name)) {
            ?[] enumConstants;
            Class<?> existing = this.classAliases.get(classdesc2.name);
            for (Object constant : enumConstants = existing.getEnumConstants()) {
                existingConstants.add(constant.toString());
            }
        }
        return existingConstants;
    }

    private Class<?> loadClass(classdesc classdesc2, boolean isInvocationHandler) throws ClassNotFoundException, IOException {
        String originalClassName = classdesc2.isInnerClass() ? this.appendOuterClassNames(classdesc2.name) : classdesc2.name;
        Optional<Class<?>> alreadyLoadedClass = this.alreadyLoadedClass(originalClassName);
        if (alreadyLoadedClass.isPresent()) {
            return alreadyLoadedClass.get();
        }
        if (!classdesc2.annotations.isEmpty()) {
            throw new ClassNotFoundException(String.format("Class '%s' could not be generated since it has been annotated with a custom annotateClass method", originalClassName));
        }
        if ((classdesc2.descflags & 1) == 1) {
            throw new ClassNotFoundException(String.format("Class '%s' could not be generated since it has a custom writeObject method", originalClassName));
        }
        boolean hasPartiallyLoadedFields = this.hasPartiallyLoadedFields(classdesc2);
        String className = hasPartiallyLoadedFields ? this.generateClassAlias(originalClassName) : originalClassName;
        Class<?> superClass = this.superClass(classdesc2);
        DynamicType.Builder.FieldDefinition.Optional typeBuilder = new ByteBuddy().subclass(superClass).implement(new Type[]{Serializable.class}).name(className).serialVersionUid(classdesc2.serialVersionUID);
        if (isInvocationHandler) {
            typeBuilder = typeBuilder.implement(new Type[]{InvocationHandler.class});
        }
        for (field classField : this.classFields(classdesc2)) {
            if (classField.type == fieldtype.OBJECT) {
                String fieldClass = this.className(classField.classname.value);
                classField.classname.value = this.fieldDescriptor(this.appendOuterClassNames(fieldClass));
            }
            typeBuilder = typeBuilder.defineField(classField.name, (TypeDefinition)this.typeOf(className, classField), this.fieldModifiers(classField));
        }
        Class<?> loaded = this.load((DynamicType.Builder<?>)typeBuilder);
        if (hasPartiallyLoadedFields) {
            this.recordAlias(originalClassName, loaded);
            this.logger.warn(String.format("Class '%s' was partially generated", originalClassName));
        } else {
            this.removeAlias(originalClassName);
            this.logger.info(String.format("Class '%s' was generated successfully", originalClassName));
        }
        return loaded;
    }

    private Set<? extends ModifierContributor.ForField> fieldModifiers(field classField) {
        if (classField.isInnerClassReference()) {
            return Collections.singleton(SyntheticState.SYNTHETIC);
        }
        return Collections.emptySet();
    }

    private void recordAlias(String className, Class<?> aliasClass) {
        this.removeAlias(className);
        this.classAliases.put(className, aliasClass);
    }

    private void removeAlias(String className) {
        Class<?> oldAlias = this.classAliases.remove(className);
        if (oldAlias != null) {
            this.deleteClassFile(oldAlias.getName());
        }
    }

    private String appendOuterClassNames(String className) {
        ArrayDeque<String> parts = new ArrayDeque<String>();
        parts.addLast(className);
        String enclosing = this.enclosingClasses.get(className);
        while (enclosing != null) {
            parts.addFirst(enclosing);
            enclosing = this.enclosingClasses.get(enclosing);
        }
        return StringUtils.join(parts, (String)"$");
    }

    private String generateClassAlias(String name) {
        return name + GENERATED_BY_TRAFFIC_PARROT + this.randomId();
    }

    private String randomId() {
        return UUID.randomUUID().toString().replace('-', 'x');
    }

    private boolean hasPartiallyLoadedFields(classdesc classdesc2) {
        return Iterables.any(this.classFields(classdesc2), (Predicate)Predicates.or(this.notLoadedObject(), this.notLoadedArray()));
    }

    private List<String> proxyInterfaces(classdesc classdesc2) {
        if (classdesc2.interfaces == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(classdesc2.interfaces);
    }

    private List<field> classFields(classdesc classdesc2) {
        if (classdesc2.fields == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(classdesc2.fields);
    }

    private Predicate<? super field> notLoadedArray() {
        return field2 -> field2.type == fieldtype.ARRAY && this.classAliases.containsKey(this.className(this.stripArrayPrefix(field2.classname.value)));
    }

    private Predicate<field> notLoadedObject() {
        return field2 -> field2.type == fieldtype.OBJECT && this.classAliases.containsKey(this.className(field2.classname.value));
    }

    private Class<?> superClass(classdesc classdesc2) throws ClassNotFoundException, IOException {
        classdesc superclass = classdesc2.superclass;
        if (superclass != null) {
            return this.loadClass(superclass, false);
        }
        return Object.class;
    }

    private TypeDescription typeOf(String classBeingGenerated, field field2) throws ClassNotFoundException, IOException {
        switch (field2.type) {
            case BYTE: {
                return new TypeDescription.ForLoadedType(Byte.TYPE);
            }
            case CHAR: {
                return new TypeDescription.ForLoadedType(Character.TYPE);
            }
            case DOUBLE: {
                return new TypeDescription.ForLoadedType(Double.TYPE);
            }
            case FLOAT: {
                return new TypeDescription.ForLoadedType(Float.TYPE);
            }
            case INTEGER: {
                return new TypeDescription.ForLoadedType(Integer.TYPE);
            }
            case LONG: {
                return new TypeDescription.ForLoadedType(Long.TYPE);
            }
            case SHORT: {
                return new TypeDescription.ForLoadedType(Short.TYPE);
            }
            case BOOLEAN: {
                return new TypeDescription.ForLoadedType(Boolean.TYPE);
            }
            case ARRAY: {
                return this.arrayType(classBeingGenerated, field2);
            }
            case OBJECT: {
                return this.classType(classBeingGenerated, field2.classname.value);
            }
        }
        throw new ClassNotFoundException("Unsupported field type: " + field2.type);
    }

    private TypeDescription classType(String classBeingGenerated, String fieldDescriptor) {
        String className = this.className(fieldDescriptor);
        Class<?> alias = this.classAliases.get(className);
        if (alias != null) {
            return new TypeDescription.ForLoadedType(alias);
        }
        if (classBeingGenerated.equals(className)) {
            return TargetType.DESCRIPTION;
        }
        Optional<Class<?>> alreadyLoadedClass = this.alreadyLoadedClass(className);
        if (alreadyLoadedClass.isPresent()) {
            return new TypeDescription.ForLoadedType(alreadyLoadedClass.get());
        }
        return InstrumentedType.Default.of((String)className, null, (int)0);
    }

    private String className(String fieldDescriptor) {
        return fieldDescriptor.replaceFirst("L", "").replace('/', '.').replaceFirst(";$", "");
    }

    private String arrayClassName(String className) {
        return "[L" + className + ";";
    }

    private String fieldDescriptor(String className) {
        return "L" + className.replace('.', '/') + ";";
    }

    private String arrayFieldDescriptor(String className) {
        return "[L" + className.replace('.', '/') + ";";
    }

    private TypeDescription arrayType(String classBeingGenerated, field field2) throws ClassNotFoundException {
        String arrayType;
        switch (arrayType = field2.classname.value) {
            case "[B": {
                return new TypeDescription.ForLoadedType(byte[].class);
            }
            case "[C": {
                return new TypeDescription.ForLoadedType(char[].class);
            }
            case "[D": {
                return new TypeDescription.ForLoadedType(double[].class);
            }
            case "[F": {
                return new TypeDescription.ForLoadedType(float[].class);
            }
            case "[I": {
                return new TypeDescription.ForLoadedType(int[].class);
            }
            case "[J": {
                return new TypeDescription.ForLoadedType(long[].class);
            }
            case "[S": {
                return new TypeDescription.ForLoadedType(short[].class);
            }
            case "[Z": {
                return new TypeDescription.ForLoadedType(boolean[].class);
            }
        }
        if (arrayType.startsWith("[L")) {
            String fieldDescriptor = this.stripArrayPrefix(arrayType);
            TypeDescription componentDescription = this.classType(classBeingGenerated, fieldDescriptor);
            return TypeDescription.ArrayProjection.of((TypeDescription)componentDescription);
        }
        throw new ClassNotFoundException("Unsupported array type: " + arrayType);
    }

    private String stripArrayPrefix(String arrayType) {
        Preconditions.checkState((boolean)arrayType.startsWith("["));
        return arrayType.substring(1);
    }

    private Optional<? extends Class<?>> alreadyLoadedClass(String name) {
        try {
            return Optional.of(Class.forName(name));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private static Object bytesToJavaObject(byte[] bytes) throws IOException, ClassNotFoundException {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = objectInputStream.readObject();
            return object;
        }
    }
}

