/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.jms;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.trafficparrot.sdk.internal.RenderableInUI;
import com.trafficparrot.sdk.jms.Destination;
import com.trafficparrot.sdk.jms.JmsResponse;
import javax.jms.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JmsResponseTransformer
implements RenderableInUI {
    protected final Logger logger;

    public JmsResponseTransformer() {
        this(LoggerFactory.getLogger(JmsResponseTransformer.class));
    }

    public JmsResponseTransformer(Logger logger) {
        this.logger = logger;
    }

    public final JmsResponse transform(Destination requestDestination, Message requestMessage, JmsResponse response, Parameters parameters) {
        try {
            JmsResponse jmsResponse = this.doTransform(requestDestination, requestMessage, response, parameters);
            if (!"NO_TRANSFORMER".equals(jmsResponse.jmsResponseTransformerClassName)) {
                String errorMessage = String.format("Please set the jmsResponseTransformerClassName to %s in %s (it was set to %s)", "NO_TRANSFORMER", this.getClass().getCanonicalName(), jmsResponse.jmsResponseTransformerClassName);
                this.logger.error(errorMessage);
                return new JmsResponse(response.destination, errorMessage);
            }
            return jmsResponse;
        }
        catch (Exception e) {
            String errorMessage = String.format("%s had a problem while transforming: %s", this.getClass().getCanonicalName(), e.getMessage());
            this.logger.error(errorMessage, (Throwable)e);
            return new JmsResponse(response.destination, errorMessage + ". See logs for more details.");
        }
    }

    @Deprecated
    protected JmsResponse doTransform(Destination requestDestination, Message requestMessage, JmsResponse response) throws Exception {
        throw new IllegalStateException(this.getDisplayName() + " must implement doTransform");
    }

    protected JmsResponse doTransform(Destination requestDestination, Message requestMessage, JmsResponse response, Parameters parameters) throws Exception {
        return this.doTransform(requestDestination, requestMessage, response);
    }

    @Override
    public String getDisplayName() {
        return this.getClass().getSimpleName();
    }
}

