/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.jms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.trafficparrot.sdk.internal.encoding.ObjectSerializedRepresentation;
import com.trafficparrot.sdk.internal.messaging.MessageBodyTypeDeserializer;
import com.trafficparrot.sdk.internal.messaging.MessageBodyTypeSerializer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Objects;

@JsonSerialize(using=MessageBodyTypeSerializer.class)
@JsonDeserialize(using=MessageBodyTypeDeserializer.class)
public class MessageBodyType {
    public static MessageBodyType TEXT = new MessageBodyType("TEXT");
    public static MessageBodyType BYTES = new MessageBodyType("BYTES");
    public static MessageBodyType PRINTABLE_CHARACTERS = new MessageBodyType("PRINTABLE_CHARACTERS");
    public static MessageBodyType UNKNOWN_BODY_TYPE = new MessageBodyType("UNKNOWN");
    private static final String PROTO_PREFIX = "proto/";
    private static final String PROTO_BASE64_BYTES_PREFIX = "protoBase64Bytes/";
    private static final String JAVA_PROTO_PREFIX = "javaProto/";
    private static final String MULTI_TYPE_SEPARATOR = ":";
    public final String value;

    public MessageBodyType(String value) {
        this.value = value;
    }

    public static MessageBodyType protoMessageType(String typeName) {
        return new MessageBodyType(PROTO_PREFIX + typeName);
    }

    public static MessageBodyType anyJavaProtoMessageType() {
        return new MessageBodyType("javaProto/*");
    }

    public static MessageBodyType anyJavaClassType() {
        return new MessageBodyType(Object.class.getName());
    }

    public static MessageBodyType javaProtoMessageType(String javaAndProtoTypeName) {
        return new MessageBodyType(JAVA_PROTO_PREFIX + javaAndProtoTypeName);
    }

    public static MessageBodyType javaProtoMessageType(String javaTypeName, String protoTypeName) {
        if (javaTypeName.equals(protoTypeName)) {
            return MessageBodyType.javaProtoMessageType(javaTypeName);
        }
        return new MessageBodyType(JAVA_PROTO_PREFIX + javaTypeName + MULTI_TYPE_SEPARATOR + protoTypeName);
    }

    public static MessageBodyType javaClassType(Object object) {
        if (Proxy.isProxyClass(object.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
            return new MessageBodyType(ObjectSerializedRepresentation.OBJECT_SERIALIZED_REPRESENTATION.externalClassName(invocationHandler.getClass().getName()));
        }
        return new MessageBodyType(ObjectSerializedRepresentation.OBJECT_SERIALIZED_REPRESENTATION.externalClassName(object.getClass().getName()));
    }

    @JsonIgnore
    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageBodyType that = (MessageBodyType)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @JsonIgnore
    public String protoMessageType() {
        return this.value.replaceFirst("^proto/", "");
    }

    @JsonIgnore
    public String protoBase64BytesMessageType() {
        return this.value.replaceFirst("^protoBase64Bytes/", "");
    }

    @JsonIgnore
    public String javaProtoJavaType() {
        String javaProtoCombinedType = this.javaProtoCombinedType();
        if (javaProtoCombinedType.contains(MULTI_TYPE_SEPARATOR)) {
            return javaProtoCombinedType.split(MULTI_TYPE_SEPARATOR)[0];
        }
        return javaProtoCombinedType;
    }

    @JsonIgnore
    public String javaProtoMessageType() {
        String javaProtoCombinedType = this.javaProtoCombinedType();
        if (javaProtoCombinedType.contains(MULTI_TYPE_SEPARATOR)) {
            return javaProtoCombinedType.split(MULTI_TYPE_SEPARATOR)[1];
        }
        return javaProtoCombinedType;
    }

    @JsonIgnore
    public boolean isProtoMessageType() {
        return this.value.startsWith(PROTO_PREFIX);
    }

    @JsonIgnore
    public boolean isProtoBase64BytesMessageType() {
        return this.value.startsWith(PROTO_BASE64_BYTES_PREFIX);
    }

    private String javaProtoCombinedType() {
        return this.value.replaceFirst("^javaProto/", "");
    }

    @JsonIgnore
    public boolean isJavaProtoMessageType() {
        return this.value.startsWith(JAVA_PROTO_PREFIX);
    }

    @JsonIgnore
    public boolean canRepresent(MessageBodyType bodyType) {
        return this.equals(bodyType) || this.isGeneralType() && bodyType.isGeneralType();
    }

    @JsonIgnore
    public boolean isJavaObject() {
        if (TEXT.equals(this) || BYTES.equals(this) || PRINTABLE_CHARACTERS.equals(this) || this.isProtoMessageType() || this.isJavaProtoMessageType()) {
            return false;
        }
        try {
            Class.forName(ObjectSerializedRepresentation.OBJECT_SERIALIZED_REPRESENTATION.internalClassName(this.value));
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @JsonIgnore
    public Class<?> javaClass() {
        try {
            return Class.forName(ObjectSerializedRepresentation.OBJECT_SERIALIZED_REPRESENTATION.internalClassName(this.value));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(String.format("The class '%s' is not on the Traffic Parrot classpath", this.value), e);
        }
    }

    private boolean isGeneralType() {
        return TEXT.equals(this) || BYTES.equals(this) || PRINTABLE_CHARACTERS.equals(this);
    }
}

