/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class PropertiesHelper {
    public static List<String> parseList(String propertyValue) {
        if (StringUtils.isBlank((CharSequence)propertyValue)) {
            return Collections.emptyList();
        }
        return Arrays.asList(propertyValue.split(","));
    }

    public static Properties readPropertiesFile(String propertiesResource) {
        try {
            Properties properties = new Properties();
            try (InputStream resourceAsStream = PropertiesHelper.class.getClassLoader().getResourceAsStream(propertiesResource);){
                properties.load(resourceAsStream);
            }
            return properties;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Properties readPropertiesFile(Path propertiesFile) {
        try {
            Properties properties = new Properties();
            try (FileInputStream resourceAsStream = new FileInputStream(propertiesFile.toFile());){
                properties.load(resourceAsStream);
            }
            return properties;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

