/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.file;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ComparisonChain;
import com.trafficparrot.sdk.file.FileMessage;
import com.trafficparrot.sdk.jms.Destination;
import com.trafficparrot.sdk.jms.MessageBodyType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class FileMessageResponse
implements Comparable<FileMessageResponse> {
    public static final String NO_TRANSFORMER = "NO_TRANSFORMER";
    public final Destination destination;
    public final String fileMessageResponseTransformerClassName;
    public final String fileName;
    public final String text;
    public final MessageBodyType bodyType;

    public FileMessageResponse(@JsonProperty(value="destination") Destination destination, @JsonProperty(value="fileMessageResponseTransformerClassName") String fileMessageResponseTransformerClassName, @JsonProperty(value="fileName") String fileName, @JsonProperty(value="text") String text, @JsonProperty(value="bodyType") MessageBodyType bodyType) {
        this.destination = destination;
        this.fileMessageResponseTransformerClassName = fileMessageResponseTransformerClassName;
        this.fileName = fileName;
        this.text = text;
        this.bodyType = bodyType;
    }

    public FileMessageResponse(Destination destination, String fileName, String text) {
        this(destination, NO_TRANSFORMER, fileName, text, MessageBodyType.TEXT);
    }

    @JsonIgnore
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public int compareTo(FileMessageResponse other) {
        return ComparisonChain.start().compare((Comparable)this.destination, (Comparable)other.destination).compare((Comparable)((Object)this.text), (Comparable)((Object)other.text)).result();
    }

    public FileMessage createResponseMessage() {
        return new FileMessage(this.fileName, this.text, System.currentTimeMillis());
    }

    public boolean hasTransformer() {
        return StringUtils.isNotBlank((CharSequence)this.fileMessageResponseTransformerClassName) && !NO_TRANSFORMER.equals(this.fileMessageResponseTransformerClassName);
    }
}

