/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.handlebars;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.google.common.collect.ForwardingMap;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrafficParrotHelper<T>
implements Helper<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected TrafficParrotHelper() {
    }

    public Object apply(T parameter, Options options) throws IOException {
        try {
            return this.doApply(parameter, options);
        }
        catch (Exception e) {
            this.logger.error(String.format("%s had a problem while transforming: %s", this.getClass().getCanonicalName(), e.getMessage()), (Throwable)e);
            return this.errorMessage(e.getMessage());
        }
    }

    protected abstract Object doApply(T var1, Options var2) throws IOException;

    protected boolean isBlockHelper() {
        return false;
    }

    public String getName() {
        String name = this.getClass().getSimpleName().replaceAll("Helper$", "");
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    protected String errorMessage(String message) {
        return TrafficParrotHelper.errorMessage(this.getName(), this.isBlockHelper(), message);
    }

    protected Map<String, Object> errorMessageMap(Context context, String message) {
        return new ErrorReportingMap(context, this.errorMessage(message));
    }

    public static String blockHelperErrorMessage(String name, String message) {
        return TrafficParrotHelper.errorMessage("#" + name, message);
    }

    public static String inlineHelperMessage(String name, String message) {
        return TrafficParrotHelper.errorMessage(" " + name, message);
    }

    private static String errorMessage(String name, boolean isBlockHelper, String message) {
        if (isBlockHelper) {
            return TrafficParrotHelper.blockHelperErrorMessage(name, message);
        }
        return TrafficParrotHelper.inlineHelperMessage(name, message);
    }

    private static String errorMessage(String helper, String message) {
        return "{{" + helper + " ERROR: " + message + " }}";
    }

    private static class ErrorReportingMap
    extends ForwardingMap<String, Object> {
        private final Context context;
        private final String errorMessage;

        public ErrorReportingMap(Context context, String errorMessage) {
            this.context = context;
            this.errorMessage = errorMessage;
        }

        protected Map<String, Object> delegate() {
            return Collections.emptyMap();
        }

        public Object get(Object key) {
            return ObjectUtils.firstNonNull((Object[])new Object[]{this.context.get(String.valueOf(key)), this.errorMessage});
        }

        public String toString() {
            return this.errorMessage;
        }
    }
}

