/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.jms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ComparisonChain;
import com.trafficparrot.sdk.jms.DestinationType;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class Destination
implements Comparable<Destination> {
    public final String name;
    public final DestinationType type;
    public final boolean skipDeclare;
    public final Map<String, Object> declareArguments;

    public Destination(String name, DestinationType type) {
        this(name, type, false, Collections.emptyMap());
    }

    @JsonCreator
    public Destination(@JsonProperty(value="name") String name, @JsonProperty(value="type") DestinationType type, @JsonProperty(value="skipDeclare") boolean skipDeclare, @JsonProperty(value="declareArguments") Map<String, Object> declareArguments) {
        this.name = name;
        this.type = type;
        this.skipDeclare = skipDeclare;
        this.declareArguments = declareArguments == null ? Collections.emptyMap() : Collections.unmodifiableMap(declareArguments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Destination that = (Destination)o;
        return Objects.equals(this.name, that.name) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type});
    }

    @JsonIgnore
    public String toString() {
        return (Object)((Object)this.type) + ":" + this.name.trim();
    }

    @Override
    public int compareTo(Destination other) {
        return ComparisonChain.start().compare((Comparable)((Object)this.name), (Comparable)((Object)other.name)).compare((Comparable)((Object)this.type), (Comparable)((Object)other.type)).result();
    }
}

