/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.jms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.google.common.collect.ComparisonChain;
import com.trafficparrot.sdk.internal.encoding.Base64Representation;
import com.trafficparrot.sdk.internal.encoding.ObjectJsonRepresentation;
import com.trafficparrot.sdk.internal.encoding.PrintableCharactersRepresentation;
import com.trafficparrot.sdk.jms.Destination;
import com.trafficparrot.sdk.jms.DestinationLookup;
import com.trafficparrot.sdk.jms.JmsMessageType;
import com.trafficparrot.sdk.jms.JmsProperty;
import com.trafficparrot.sdk.jms.MessageBodyType;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.jms.Message;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class JmsResponse
implements Comparable<JmsResponse> {
    public static final String NO_TRANSFORMER = "NO_TRANSFORMER";
    public final Destination destination;
    public final String jmsResponseTransformerClassName;
    public final Parameters jmsResponseTransformerParameters;
    public final String text;
    public final MessageBodyType bodyType;
    public final String jmsMessageType;
    public final List<JmsProperty> properties;
    public final Optional<DestinationLookup> destinationLookup;
    public final long fixedDelayMilliseconds;
    public final transient Optional<Message> responseMessage;

    public JmsResponse(@JsonProperty(value="destination") Destination destination, @JsonProperty(value="jmsResponseTransformerClassName") String jmsResponseTransformerClassName, @JsonProperty(value="jmsResponseTransformerParameters") Parameters jmsResponseTransformerParameters, @JsonProperty(value="text") String text, @JsonProperty(value="bodyType") MessageBodyType bodyType, @JsonProperty(value="jmsMessageType") String jmsMessageType, @JsonProperty(value="properties") List<JmsProperty> properties, @JsonProperty(value="fixedDelayMilliseconds") Long fixedDelayInMilliseconds, @JsonProperty(value="destinationLookup") Optional<DestinationLookup> destinationLookup, @JsonProperty(value="never-serialized-field") Optional<Message> responseMessage) {
        this.destination = destination;
        this.jmsResponseTransformerClassName = jmsResponseTransformerClassName;
        this.jmsResponseTransformerParameters = jmsResponseTransformerParameters;
        this.text = text;
        this.bodyType = (MessageBodyType)ObjectUtils.firstNonNull((Object[])new MessageBodyType[]{bodyType, MessageBodyType.TEXT});
        this.jmsMessageType = (String)ObjectUtils.firstNonNull((Object[])new String[]{jmsMessageType, JmsMessageType.jmsMessageType(this.bodyType)});
        this.properties = (List)ObjectUtils.firstNonNull((Object[])new List[]{properties, Collections.emptyList()});
        this.fixedDelayMilliseconds = (Long)ObjectUtils.firstNonNull((Object[])new Long[]{fixedDelayInMilliseconds, 0L});
        this.destinationLookup = destinationLookup;
        this.responseMessage = responseMessage;
    }

    public JmsResponse(Destination destination, String jmsResponseTransformerClassName, String text, MessageBodyType bodyType, String jmsMessageType, List<JmsProperty> properties, Long fixedDelayInMilliseconds) {
        this(destination, jmsResponseTransformerClassName, null, text, bodyType, jmsMessageType, properties, fixedDelayInMilliseconds, Optional.empty(), Optional.empty());
    }

    public JmsResponse(Destination destination, String jmsResponseTransformerClassName, String text, MessageBodyType bodyType, List<JmsProperty> properties, long fixedDelayInMilliseconds) {
        this(destination, jmsResponseTransformerClassName, text, bodyType, JmsMessageType.jmsMessageType(bodyType), properties, fixedDelayInMilliseconds);
    }

    public JmsResponse(Destination destination, String jmsResponseTransformerClassName, String text, MessageBodyType bodyType) {
        this(destination, jmsResponseTransformerClassName, text, bodyType, JmsMessageType.jmsMessageType(bodyType), Collections.emptyList(), 0L);
    }

    public JmsResponse(Destination destination, String jmsResponseTransformerClassName, String text) {
        this(destination, jmsResponseTransformerClassName, text, MessageBodyType.TEXT);
    }

    public JmsResponse(Destination destination, String text) {
        this(destination, NO_TRANSFORMER, text);
    }

    public JmsResponse(Destination destination, String jmsResponseTransformerClassName, Object object) throws JsonProcessingException {
        this(destination, jmsResponseTransformerClassName, ObjectJsonRepresentation.objectToJson(object), MessageBodyType.javaClassType(object));
    }

    public JmsResponse(Destination destination, Object object) throws JsonProcessingException {
        this(destination, NO_TRANSFORMER, object);
    }

    public static JmsResponse base64BytesResponse(Destination destination, byte[] bytes) {
        return JmsResponse.base64BytesResponse(destination, NO_TRANSFORMER, bytes);
    }

    public static JmsResponse base64BytesResponse(Destination destination, String jmsResponseTransformerClassName, byte[] bytes) {
        return new JmsResponse(destination, jmsResponseTransformerClassName, Base64Representation.encodeBase64(bytes), MessageBodyType.BYTES);
    }

    public static JmsResponse printableCharactersBytesResponse(Destination destination, byte[] bytes) {
        return JmsResponse.printableCharactersBytesResponse(destination, NO_TRANSFORMER, bytes);
    }

    public static JmsResponse printableCharactersBytesResponse(Destination destination, String jmsResponseTransformerClassName, byte[] bytes) {
        return new JmsResponse(destination, jmsResponseTransformerClassName, PrintableCharactersRepresentation.encodePrintableCharacters(bytes), MessageBodyType.PRINTABLE_CHARACTERS);
    }

    @JsonIgnore
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public int compareTo(JmsResponse other) {
        return ComparisonChain.start().compare((Comparable)this.destination, (Comparable)other.destination).compare((Comparable)((Object)this.text), (Comparable)((Object)other.text)).result();
    }

    public boolean hasTransformer() {
        return StringUtils.isNotBlank((CharSequence)this.jmsResponseTransformerClassName) && !NO_TRANSFORMER.equals(this.jmsResponseTransformerClassName);
    }

    public void validate() throws IOException {
        if (this.bodyType.isJavaObject()) {
            String textWithoutTemplateTokens = this.text.replaceAll("\\{\\{.*}}", "null");
            ObjectJsonRepresentation.jsonToObject(textWithoutTemplateTokens, this.bodyType.javaClass());
        }
    }
}

