package com.trafficparrot.sdk.example.http;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.trafficparrot.sdk.http.HttpResponseTransformer;

import java.util.concurrent.ThreadLocalRandom;

import static com.github.tomakehurst.wiremock.http.HttpHeaders.noHeaders;

public class RandomServerFailure extends HttpResponseTransformer {
    @Override
    protected Response doTransform(Request request, Response response, FileSource fileSource, Parameters parameters) {
        if (ThreadLocalRandom.current().nextBoolean()) {
            return Response.Builder
                    .like(response)
                    .but()
                    .status(500)
                    .headers(noHeaders())
                    .body("Server error!")
                    .build();
        } else {
            return response;
        }
    }

    @Override
    public boolean applyGlobally() {
        return true;
    }

    @Override
    public String getName() {
        return getClass().getSimpleName();
    }
}
