package com.trafficparrot.sdk.example.jms;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.trafficparrot.sdk.jms.Destination;
import com.trafficparrot.sdk.jms.JmsResponse;
import com.trafficparrot.sdk.jms.JmsResponseBuilder;
import com.trafficparrot.sdk.jms.TextJmsResponseTransformer;

import javax.jms.TextMessage;
import java.util.ArrayList;
import java.util.List;

public class GenerateJsonResponseBasedOnRequest extends TextJmsResponseTransformer {
    @Override
    protected JmsResponse doTransform(Destination requestDestination, TextMessage requestMessage, JmsResponse response, Parameters parameters) throws Exception {
        Order requestOrder = Json.read(requestMessage.getText(), Order.class);

        List<OrderedItem> responseOrderedItems = new ArrayList<>();
        for (int i = 0; i < requestOrder.orderItems.size(); i++) {
            OrderItem orderItem = requestOrder.orderItems.get(i);
            OrderedItem orderedItem = new OrderedItem();
            orderedItem.orderItemId = orderItem.orderItemId;
            orderedItem.quantity = orderItem.quantity;
            orderedItem.sku = orderItem.partnumber;
            responseOrderedItems.add(orderedItem);
        }

        OrderAcceptance orderAcceptance = new OrderAcceptance();
        orderAcceptance.orderAccepted = responseOrderedItems.size() % 2 == 0;
        orderAcceptance.orderItems = responseOrderedItems;

        return new JmsResponseBuilder()
                .like(response)
                .withText(Json.write(orderAcceptance))
                .build();
    }
}

class Order {
    public long orderId;
    public long storeId;
    public List<OrderItem> orderItems;
}

class OrderItem {
    public long orderItemId;
    public String partnumber;
    public int quantity;
}

class OrderAcceptance {
    public boolean orderAccepted;
    public List<OrderedItem> orderItems = new ArrayList<>();
}

class OrderedItem {
    public long orderItemId;
    public int quantity;
    public String sku;
}