package com.trafficparrot.sdk.example.http;

import com.github.tomakehurst.wiremock.http.Response;
import org.junit.Test;

import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.mock;

public class RandomServerFailureTest {
    private static final Response ORIGINAL_RESPONSE = mock(Response.class);

    @Test
    public void randomlyGeneratesAnError() throws Exception {
        boolean foundOneNotTransformed = false;
        boolean foundOneTransformed = false;

        for (int i = 0; i < 50; i++) {
            Response transformed = new RandomServerFailure().transform(null, ORIGINAL_RESPONSE, null, null);
            if (transformed == ORIGINAL_RESPONSE) {
                foundOneNotTransformed = true;
            }
            if (transformed.getStatus() == 500) {
                foundOneTransformed = true;
            }
        }

        assertTrue(foundOneNotTransformed);
        assertTrue(foundOneTransformed);
    }
}