package com.trafficparrot.sdk.example.template;


import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.trafficparrot.sdk.example.handlebars.RandomInteger;
import org.junit.Test;

import java.io.IOException;

import static com.github.jknack.handlebars.helper.StringHelpers.stringFormat;
import static java.util.Collections.emptyMap;
import static org.assertj.core.api.Assertions.assertThat;

public class RandomIntegerTest {

    private final RandomInteger randomInteger = new RandomInteger();
    private final Handlebars handlebars = new Handlebars().with(EscapingStrategy.NOOP)
            .registerHelper(stringFormat.name(), stringFormat)
            .registerHelper(randomInteger.getName(), randomInteger);

    @Test
    public void name() {
        assertThat(randomInteger.getName()).isEqualTo("randomInteger");
    }

    @Test
    public void randomIntegerReturnsInteger() {
        assertThat(randomInteger.doApply(null, null)).isInstanceOf(Integer.class);
    }

    @Test
    public void useInStringFormat() throws IOException {
        Template template = handlebars.compileInline("{{ stringFormat 'Hello %02d world' (randomInteger 0 9)}}");
        String apply = template.apply(emptyMap());

        assertThat(apply).matches("Hello 0\\d world");
    }

    @Test
    public void randomIntegerWithNoArguments() throws IOException {
        Template template = handlebars.compileInline("{{ randomInteger }}");
        String apply = template.apply(emptyMap());

        assertThat(Integer.parseInt(apply)).isNotNull();
    }

    @Test
    public void randomIntegerBetweenPositiveAndPositive() throws IOException {
        Template template = handlebars.compileInline("{{ randomInteger 5 10 }}");
        String apply = template.apply(emptyMap());

        assertThat(Integer.parseInt(apply)).isGreaterThanOrEqualTo(5).isLessThanOrEqualTo(10);
    }

    @Test
    public void randomIntegerBetweenZeroAndPositive() throws IOException {
        Template template = handlebars.compileInline("{{ randomInteger 0 5 }}");
        String apply = template.apply(emptyMap());

        assertThat(Integer.parseInt(apply)).isGreaterThanOrEqualTo(0).isLessThanOrEqualTo(5);
    }

    @Test
    public void randomIntegerBetweenNegativeAndZero() throws IOException {
        Template template = handlebars.compileInline("{{ randomInteger -5 0 }}");
        String apply = template.apply(emptyMap());

        assertThat(Integer.parseInt(apply)).isGreaterThanOrEqualTo(-5).isLessThanOrEqualTo(0);
    }

    @Test
    public void randomIntegerBetweenNegativeAndNegative() throws IOException {
        Template template = handlebars.compileInline("{{ randomInteger -10 -5 }}");
        String apply = template.apply(emptyMap());

        assertThat(Integer.parseInt(apply)).isGreaterThanOrEqualTo(-10).isLessThanOrEqualTo(-5);
    }
}