@file:Suppress("UnstableApiUsage", "DEPRECATION")

group = "com.trafficparrot"
version = "5.58.0-SNAPSHOT"

plugins {
    id("java")
    id("com.trafficparrot").version("5.58.0-SNAPSHOT")
}

repositories {
    maven("https://repo1.maven.org/maven2/")
    mavenLocal()
}

dependencies {
    testImplementation("javax.jms", "javax.jms-api", "2.0.1")
    testImplementation("org.apache.activemq", "activemq-client", "5.16.8")
    testImplementation("org.apache.httpcomponents", "httpclient", "4.5.14")
    testImplementation("org.slf4j", "slf4j-simple", "2.0.17")
    testImplementation("commons-io", "commons-io", "2.20.0")
    testImplementation("commons-codec", "commons-codec", "1.18.0")
    testImplementation("junit", "junit", "4.13.2")
    testImplementation("org.assertj", "assertj-core", "3.25.3")
    testImplementation("org.json", "json", "20250517")
    testImplementation("org.xmlunit", "xmlunit-assertj", "2.10.0")
    testImplementation("net.bytebuddy", "byte-buddy", "1.14.13")
}

configure<JavaPluginExtension> {
    sourceCompatibility = JavaVersion.VERSION_1_8
    targetCompatibility = JavaVersion.VERSION_1_8
}

startTrafficParrot {
    // This can either be a file or a URL location of the Traffic Parrot release .zip file
    downloadFrom = file("C:\some\path\to\trafficparrot-no-jre-5.57.0.zip").toURL()

    // Set this to true to indicate that you accept the Traffic Parrot LICENSE terms
    acceptLicense = false

    // Set this to true if you would like to cache the download in the java.io.tmpdir
    cacheDownload = false

    // Set this to the location of your Traffic Parrot enterprise license file
    licenseFile = file("/path/to/trafficparrot.license").toURL()

    trafficFilesRoot = file(project.projectDir.absolutePath + "/src/test/resources/trafficparrot")

    // This will import Swagger/OpenAPI/RAML specifications
    httpImportMappings = true

    httpVirtualServicePort = 18081
    httpsVirtualServicePort = 18082

    jmsConnectionsFile = file(project.projectDir.absolutePath + "/src/test/resources/trafficparrot/jms-connections.json").toURL()

    jmsBrokerType = "INTERNAL"
    jmsInternalBrokerPort = 19091
    jmsInternalBrokerProvider = "ACTIVE_MQ"
    jmsReplayQueue = true
    jmsQueueConsumeRequestsFromConnectionId = "USE-TRAFFIC-PARROT-INTERNAL-BROKER"
    jmsQueueReplayResponsesToConnectionId = "example-connection-id"
    jmsReplayTopic = true
    jmsTopicReplayToConnectionId = "example-connection-id"
}

stopTrafficParrot {
    deleteAfterStop = true
}

defaultTasks(tasks.clean.get(), tasks.startTrafficParrot.get(), tasks.test.get(), tasks.stopTrafficParrot.get())

buildscript {
    configurations.getByName("classpath") {
        resolutionStrategy.cacheChangingModulesFor(0, TimeUnit.SECONDS)
    }
}