package com.trafficparrot.examples.hello.ibmmq;

import com.ibm.mq.*;
import com.ibm.mq.constants.CMQC;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import static java.lang.String.format;

public class WaitForOneIbmMqMessage implements Runnable {

    private final ExecutorService executor;
    private final MQQueueManager mqQueueManager;
    private final MQDestination mqDestination;

    private String message;

    WaitForOneIbmMqMessage(MQQueueManager mqQueueManager, MQDestination mqDestination) {
        this.mqQueueManager = mqQueueManager;
        this.mqDestination = mqDestination;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public String awaitMessage() throws InterruptedException, MQException {
        return awaitMessage(10, TimeUnit.SECONDS);
    }

    private String awaitMessage(int timeout, TimeUnit timeUnit) throws InterruptedException, MQException {
        executor.execute(this);
        executor.shutdown();
        boolean terminated = executor.awaitTermination(timeout, timeUnit);
        close();
        if (!terminated || message == null) {
            throw new IllegalStateException(format("0/1 messages arrived in %s %s", timeout, timeUnit));
        }
        return message;
    }

    @Override
    public void run() {
        try {
            MQMessage mqMessage = new MQMessage();
            MQGetMessageOptions mqGetMessageOptions = new MQGetMessageOptions();
            mqGetMessageOptions.options = CMQC.MQGMO_WAIT | CMQC.MQGMO_FAIL_IF_QUIESCING;
            mqGetMessageOptions.waitInterval = 10_000;
            mqDestination.get(mqMessage, mqGetMessageOptions);
            message = mqMessage.readStringOfByteLength(mqMessage.getDataLength());
        } catch (MQException | IOException e) {
            throw new RuntimeException("Problem waiting for MQ message", e);
        }
    }

    public void close() throws MQException {
        mqDestination.close();
        mqQueueManager.disconnect();
        mqQueueManager.close();
    }
}
