/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformedRequestDefinition
extends ResponseDefinition {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformedRequestDefinition.class);
    protected final Request transformedRequest;

    public void setOriginalRequest(Request originalRequest) {
        LOGGER.info("Overriding original request. Using transformed request:" + System.lineSeparator() + this.transformedRequest + System.lineSeparator() + System.lineSeparator() + "and disregarding: " + System.lineSeparator() + System.lineSeparator() + originalRequest);
        super.setOriginalRequest(this.transformedRequest);
    }

    public TransformedRequestDefinition(ResponseDefinition original, Request transformedRequest) {
        super(original.getStatus(), original.getStatusMessage(), original.getByteBody(), (JsonNode)new TextNode(original.getBody()), original.getBase64Body(), original.getBodyFileName(), original.getHeaders(), original.getAdditionalProxyRequestHeaders(), original.getFixedDelayMilliseconds(), original.getDelayDistribution(), original.getChunkedDribbleDelay(), original.getProxyBaseUrl(), original.getProxyUrlPrefixToRemove(), original.getFault(), original.getTransformers(), original.getTransformerParameters(), Boolean.valueOf(original.wasConfigured()));
        this.transformedRequest = transformedRequest;
        super.setOriginalRequest(transformedRequest);
    }

    public ResponseDefinition copy() {
        return new TransformedRequestDefinition(this, this.transformedRequest);
    }

    public String toString() {
        return "TransformedRequestDefinition{transformedRequest=" + this.transformedRequest + '}';
    }
}

