/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.ibmmq;

import com.ibm.mq.MQDestination;
import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.headers.MQDataException;
import com.ibm.mq.headers.MQHeaderIterator;
import com.trafficparrot.sdk.internal.encoding.PrintableCharactersRepresentation;
import java.io.DataInput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkIbmMqUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SdkIbmMqUtils.class);
    public static boolean logMessageBody = true;
    public static boolean logMessageBodyAsPrintableCharacters = false;

    public static String resolvedDestinationName(MQDestination mqDestination) throws MQException {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{mqDestination.getResolvedQName(), mqDestination.getResolvedObjectString(), mqDestination.getName()});
    }

    public static void closeQuietly(MQDestination mqDestination) {
        try {
            if (mqDestination != null) {
                LOGGER.info("Closing " + SdkIbmMqUtils.resolvedDestinationName(mqDestination));
                mqDestination.close();
                LOGGER.info("Closed " + SdkIbmMqUtils.resolvedDestinationName(mqDestination));
            }
        }
        catch (MQException e) {
            LOGGER.debug("Closing problem", (Throwable)e);
        }
    }

    public static void disconnectQuietly(MQQueueManager mqQueueManager) {
        try {
            if (mqQueueManager != null) {
                LOGGER.info("Disconnecting from QM " + mqQueueManager.getName());
                mqQueueManager.disconnect();
            }
        }
        catch (MQException e) {
            LOGGER.debug("Disconnect problem", (Throwable)e);
        }
    }

    public static void disconnectAndCloseQuietly(MQQueueManager mqQueueManager) {
        try {
            if (mqQueueManager != null) {
                LOGGER.info("Disconnecting and closing QM " + mqQueueManager.getName());
                mqQueueManager.disconnect();
                mqQueueManager.close();
            }
        }
        catch (MQException e) {
            LOGGER.debug("Disconnecting and closing problem", (Throwable)e);
        }
    }

    public static String mqMessageToString(MQMessage message) {
        try {
            return String.format(message.getClass().getName() + "%nformat=%s%nmessageId=%s%ncorrelationId=%s%nreplyToQueueName=%s%nreplyToQueueManagerName=%s%nmessage=%s%nmessageSequenceNumber=%d%nuserId=%s%nputApplicationName=%s%nputDateTime=%s%ncharacterSet=%s%nproperties=%n%s", message.format, SdkIbmMqUtils.messageIdToString(message), SdkIbmMqUtils.correlationIdToString(message), message.replyToQueueName, message.replyToQueueManagerName, logMessageBody ? SdkIbmMqUtils.toString(message) : "(logging message body disabled, to enable set the required property)", message.messageSequenceNumber, StringUtils.defaultIfBlank((CharSequence)message.userId, (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)message.putApplicationName, (CharSequence)""), SdkIbmMqUtils.putDateTime(message), message.characterSet, SdkIbmMqUtils.properties(message));
        }
        catch (Exception e) {
            LOGGER.error("Error converting MQMessage to string. Message: " + message.toString(), (Throwable)e);
            return "Error converting MQMessage to string:\n" + message.toString();
        }
    }

    private static String toString(MQMessage message) throws IOException {
        return logMessageBodyAsPrintableCharacters ? SdkIbmMqUtils.readPrintableCharacters(message) : SdkIbmMqUtils.utf8String(message);
    }

    private static String utf8String(MQMessage message) throws IOException {
        return new String(SdkIbmMqUtils.readMessageBytes(message), StandardCharsets.UTF_8);
    }

    private static String properties(MQMessage b) throws MQException {
        Enumeration propertyNames = b.getPropertyNames("%");
        StringBuilder result = new StringBuilder();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            Object value = b.getObjectProperty(name);
            result.append("      ");
            result.append(name);
            result.append(":");
            result.append(value);
            result.append(":").append(value.getClass().getName());
            result.append(System.lineSeparator());
        }
        return result.toString();
    }

    public static String messageIdToString(MQMessage message) {
        return SdkIbmMqUtils.byteArrayAsHexString(message.messageId);
    }

    public static String correlationIdToString(MQMessage message) {
        byte[] correlationId = message.correlationId;
        return SdkIbmMqUtils.byteArrayAsHexString(correlationId);
    }

    public static String byteArrayAsHexString(byte[] correlationId) {
        return Hex.encodeHexString((byte[])correlationId).toUpperCase();
    }

    public static String readMessageString(MQMessage message) throws IOException {
        int offset = message.getDataOffset();
        message.seek(0);
        String data = message.readStringOfByteLength(message.getDataLength());
        message.seek(offset);
        return data;
    }

    public static byte[] readMessageBytes(MQMessage message) throws IOException {
        int offset = message.getDataOffset();
        message.seek(0);
        byte[] data = new byte[message.getDataLength()];
        message.readFully(data);
        message.seek(offset);
        return data;
    }

    private static String readPrintableCharacters(MQMessage message) throws IOException {
        return PrintableCharactersRepresentation.encodePrintableCharacters(SdkIbmMqUtils.readMessageBytes(message));
    }

    public static String putDateTime(MQMessage message) {
        return SdkIbmMqUtils.formatPutDateTime(message.putDateTime);
    }

    public static String formatPutDateTime(GregorianCalendar putDateTime) {
        if (putDateTime == null) {
            return "null";
        }
        return Instant.ofEpochMilli(putDateTime.getTimeInMillis()).atZone(putDateTime.getTimeZone().toZoneId()).format(DateTimeFormatter.ISO_INSTANT);
    }

    public static String readMessageBodySkipHeaders(MQMessage message) throws IOException {
        int offset = message.getDataOffset();
        message.seek(0);
        SdkIbmMqUtils.skipHeaders(message);
        String data = message.readStringOfByteLength(message.getDataLength());
        message.seek(offset);
        return data;
    }

    public static void setMessageBody(MQMessage message, String body) throws IOException {
        message.seek(0);
        SdkIbmMqUtils.skipHeaders(message);
        message.writeString(body);
        message.resizeBuffer(message.getDataOffset());
    }

    private static void skipHeaders(MQMessage message) throws IOException {
        if ("MQHRF2  ".equals(message.format) || "MQHRF   ".equals(message.format)) {
            MQHeaderIterator it = new MQHeaderIterator((DataInput)message);
            try {
                it.skipHeaders();
            }
            catch (MQDataException e) {
                throw new IllegalArgumentException("Problem stripping RFH header for message " + SdkIbmMqUtils.byteArrayAsHexString(message.messageId), e);
            }
        }
    }
}

