/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.internal.encoding;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.lang.reflect.Proxy;

public class ObjectJsonRepresentation {
    private static final ObjectMapper OBJECT_JSON_MAPPER = ObjectJsonRepresentation.objectMapper();

    public static String objectToJson(Object object) throws JsonProcessingException {
        if (object instanceof Proxy) {
            return OBJECT_JSON_MAPPER.writeValueAsString((Object)Proxy.getInvocationHandler(object));
        }
        return OBJECT_JSON_MAPPER.writeValueAsString(object);
    }

    public static <T> T jsonToObject(String text, Class<T> type) throws IOException {
        return (T)OBJECT_JSON_MAPPER.readValue(text, type);
    }

    private static ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        return objectMapper;
    }
}

