/*
 * Decompiled with CFR 0.152.
 */
package com.trafficparrot.sdk.jms;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.trafficparrot.sdk.internal.encoding.Base64Representation;
import com.trafficparrot.sdk.internal.encoding.ObjectJsonRepresentation;
import com.trafficparrot.sdk.jms.Destination;
import com.trafficparrot.sdk.jms.JmsResponse;
import com.trafficparrot.sdk.jms.MessageBodyType;

public class JmsResponseBuilder {
    private Destination destination;
    private String text;
    private MessageBodyType bodyType;

    public JmsResponseBuilder like(JmsResponse response) {
        this.destination = response.destination;
        this.text = response.text;
        this.bodyType = response.bodyType;
        return this;
    }

    public JmsResponseBuilder withText(String text) {
        this.text = text;
        this.bodyType = MessageBodyType.TEXT;
        return this;
    }

    public JmsResponseBuilder withBytes(byte[] bytes) {
        this.text = Base64Representation.encodeBase64(bytes);
        this.bodyType = MessageBodyType.BYTES;
        return this;
    }

    public JmsResponseBuilder withObject(Object object) throws JsonProcessingException {
        this.text = ObjectJsonRepresentation.objectToJson(object);
        this.bodyType = MessageBodyType.javaClassType(object);
        return this;
    }

    public JmsResponseBuilder withDestination(Destination destination) {
        this.destination = destination;
        return this;
    }

    public JmsResponse build() {
        return new JmsResponse(this.destination, "NO_TRANSFORMER", this.text, this.bodyType);
    }
}

