package com.trafficparrot.sdk.example.http;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.jayway.jsonpath.JsonPath;
import com.trafficparrot.sdk.http.HttpResponseTransformer;

import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;

import static com.github.tomakehurst.wiremock.http.Response.Builder.like;
import static com.trafficparrot.sdk.PropertiesHelper.readPropertiesFile;

public class CustomJdbcResponseTransformer extends HttpResponseTransformer {

    private static final String QUERY = "SELECT name FROM person WHERE id = ?";

    @Override
    public Response doTransform(Request request, Response response, FileSource fileSource, Parameters parameters) throws Exception {
        Properties properties = (Properties) parameters.get("properties");

        Properties custom = readPropertiesFile(Paths.get(properties.getProperty("scenarioDirectory")).resolve(getName() + ".properties"));
        String url = custom.getProperty("jdbc.url");
        try (Connection connection = DriverManager.getConnection(url, custom);
             PreparedStatement statement = connection.prepareStatement(QUERY)) {

            int id = JsonPath.read(request.getBodyAsString(), "$.id");
            statement.setInt(1, id);

            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                return like(response).status(500).body(QUERY + " returned no results").build();
            }
            String result = String.valueOf(resultSet.getObject(1));
            return like(response).body("{\"name\": \"" + result + "\"}").build();
        }
    }

    @Override
    public String getName() {
        return getClass().getSimpleName();
    }
}
