package com.trafficparrot.sdk.example.jms;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.trafficparrot.sdk.jms.Destination;
import com.trafficparrot.sdk.jms.JmsResponse;
import com.trafficparrot.sdk.jms.JmsResponseBuilder;
import com.trafficparrot.sdk.jms.TextJmsResponseTransformer;

import javax.jms.JMSException;
import javax.jms.TextMessage;

public class ChooseResponseQueueBasedOnRequestMessageBody extends TextJmsResponseTransformer {
    @Override
    protected JmsResponse doTransform(Destination requestDestination, TextMessage requestMessage, JmsResponse response, Parameters parameters) throws JMSException {
        Req payment = Json.read(requestMessage.getText(), Req.class);
        String newDestinationName;
        if ("foo".equals(payment.requestField)) {
            newDestinationName = "response_queue_1";
        } else if ("bar".equals(payment.requestField)) {
            newDestinationName = "response_queue_2";
        } else {
            logger.error("Destination not configured for req.requestField '" + payment.requestField + "'");
            throw new UnsupportedOperationException(payment.requestField);
        }
        logger.info("Redirecting message to " + newDestinationName);

        return new JmsResponseBuilder()
                .like(response)
                .withDestination(new Destination(newDestinationName, response.destination.type))
                .build();
    }
}

class Req {
    public String requestField;
}