package com.trafficparrot.sdk.example.jms;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.trafficparrot.sdk.jms.Destination;
import com.trafficparrot.sdk.jms.JmsResponse;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Test;

import javax.jms.TextMessage;

import static com.trafficparrot.sdk.jms.DestinationType.QUEUE;
import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class GenerateJsonResponseBasedOnRequestTest {
    private static final Destination REQUEST_DESTINATION = new Destination("order_queue", QUEUE);
    private static final Destination RESPONSE_DESTINATION = new Destination("response_queue", QUEUE);
    private static final JmsResponse RESPONSE = new JmsResponse(RESPONSE_DESTINATION,  "response text");
    private static final String N = SystemUtils.LINE_SEPARATOR;
    private final GenerateJsonResponseBasedOnRequest generateResponseBasedOnRequest = new GenerateJsonResponseBasedOnRequest();
    private final TextMessage requestMessage = mock(TextMessage.class);

    @Test
    public void createsAResponseWithOddNumberOfItemsAndOrderAcceptedFalse() throws Exception {
        when(requestMessage.getText()).thenReturn("{" + N +
                "   \"orderId\": 9999888800001," + N +
                "   \"storeId\": 34009450," + N+
                "   \"orderItems\": [{" +
                "     \"orderItemId\": 999988880000101," + N +
                "     \"partnumber\": \"0012311077738\"," + N +
                "     \"quantity\": 1" + N +
                "   }]}" + N +
                " ");

        JmsResponse response = generateResponseBasedOnRequest.transform(REQUEST_DESTINATION, requestMessage, RESPONSE, new Parameters());

        assertEquals(
                "{" + N +
                        "  \"orderAccepted\" : false," + N +
                        "  \"orderItems\" : [ {" + N +
                        "    \"orderItemId\" : 999988880000101," + N +
                        "    \"quantity\" : 1," + N +
                        "    \"sku\" : \"0012311077738\"" + N +
                        "  } ]" + N +
                        "}", response.text);
    }

    @Test
    public void createsAResponseWithEvenNumberOfItemsAndOrderAcceptedTrue() throws Exception {
        when(requestMessage.getText()).thenReturn("{" + N +
                "   \"orderId\": 9999888800001," + N +
                "   \"storeId\": 34009450," + N +
                "   \"orderItems\": [{" +
                "     \"orderItemId\": 999988880000101," + N +
                "     \"partnumber\": \"0012311077738\"," + N +
                "     \"quantity\": 1" + N +
                "   }, {" +
                "     \"orderItemId\": 999988880000102," + N +
                "     \"partnumber\": \"0012311077739\"," + N +
                "     \"quantity\": 10" + N +
                "   }]}" + N +
                " ");

        JmsResponse response = generateResponseBasedOnRequest.transform(REQUEST_DESTINATION, requestMessage, RESPONSE, new Parameters());

        assertEquals(
                "{" + N +
                        "  \"orderAccepted\" : true," + N +
                        "  \"orderItems\" : [ {" + N +
                        "    \"orderItemId\" : 999988880000101," + N +
                        "    \"quantity\" : 1," + N +
                        "    \"sku\" : \"0012311077738\"" + N +
                        "  }, {" + N +
                        "    \"orderItemId\" : 999988880000102," + N +
                        "    \"quantity\" : 10," + N +
                        "    \"sku\" : \"0012311077739\"" + N +
                        "  } ]" + N +
                        "}", response.text);
    }

}